/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 2021-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_COMPATIBILITY_H
#define CUBEGUI_COMPATIBILITY_H
#include <QtGlobal>

#if QT_VERSION >= QT_VERSION_CHECK( 5, 0, 0 ) // at least 5.0.0
#define HAS_QREGULAR_EXPRESSION
#endif

#if QT_VERSION >= QT_VERSION_CHECK( 5, 15, 0 ) // at least 5.15.0
#define HAS_QREGULAR_WILDCARD_EXPRESSION
#endif

#if QT_VERSION < QT_VERSION_CHECK( 5, 14, 0 )
#include <QString>
constexpr QString::SplitBehavior SkipEmptyParts = QString::SkipEmptyParts;
#else
#include <qnamespace.h>
constexpr Qt::SplitBehaviorFlags SkipEmptyParts = Qt::SkipEmptyParts;
#endif

#ifdef __MINGW32__
#define __mingw_aligned_malloc aligned_alloc
#define __mingw_aligned_free free
#endif


#endif // COMPATIBILITY_H
