/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_CONTEXTFREESERVICES_H
#define CUBEGUI_CONTEXTFREESERVICES_H

#include <QWidget>
#include "Globals.h"

#include "CubeClientConnection.h"

namespace cube
{
class CubeProxy;
}

namespace cubegui
{
class MainWidget;
enum MessageType;
}

namespace cubepluginapi
{
class ContextFreeServices : public QObject
{
    Q_OBJECT
public:
    static ContextFreeServices*
    getInstance();

    /** closes this plugin and loads the given cube */
    void
    openCube( cube::CubeProxy* cube );

    /** returns a widget on the main screen which can be used by the plugin. If the plugin is closed, all
     * children of the widget are deleted.
     */
    QWidget*
    getWidget();

    /** Writes the given message to the status line at the bottom of the cube window */
    void
    setMessage( const QString&       str,
                cubegui::MessageType type = cubegui::Information );

    /** connect to server (e.g. "cube://localhost:3300" ) before sendToPlugin is called */
    bool
    connect( const QString& serverUrl );
    void
    disconnect();

    /** send data to the server side plugin identified by serverPluginName and wait for an answer */
    std::vector<unsigned char>
    sendToPlugin( const QString&                    serverPluginName,
                  const std::vector<unsigned char>& data );


    friend class cubegui::MainWidget;
signals:
    void
    openCubeRequest( cube::CubeProxy* cube );

private:
    ContextFreeServices();
    void
    setWidget( QWidget* ); // called by MainWidget

    static ContextFreeServices* single;
    QWidget*                    widget;
    cube::ClientConnection::Ptr clientConnection; // client connection to cube server
};
}
#endif // CONTEXTFREESERVICES_H
