/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2023                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#include "config.h"

#include "ContextFreeServices.h"
#include "CubeProxy.h"
#include "CubePluginRequest.h"
#include "CubeSocket.h"
#include "qdebug.h"

using namespace cubegui;
using namespace cube;
using namespace cubepluginapi;

ContextFreeServices* ContextFreeServices::single = 0;

ContextFreeServices::ContextFreeServices()
{
}

ContextFreeServices*
ContextFreeServices::getInstance()
{
    if ( single == 0 )
    {
        single = new ContextFreeServices();
    }
    return single;
}

void
ContextFreeServices::openCube( cube::CubeProxy* cube )
{
    disconnect();
    emit openCubeRequest( cube );
}

QWidget*
ContextFreeServices::getWidget()
{
    return widget;
}

void
ContextFreeServices::setWidget( QWidget* w )
{
    widget = w;
}

void
ContextFreeServices::setMessage( const QString& str, MessageType type )
{
    Globals::setStatusMessage( str, type );
}

bool
ContextFreeServices::connect( const QString& serverUrl  )
{
    disconnect();
    clientConnection = cube::ClientConnection::create( Socket::create(), serverUrl.toStdString() );

    return true;
}

void
ContextFreeServices::disconnect()
{
    if ( clientConnection != nullptr )
    {
        clientConnection.reset();
    }
}

std::vector<unsigned char>
ContextFreeServices::sendToPlugin( const QString& serverPluginName, const std::vector<unsigned char>& data )
{
    std::vector<unsigned char> answer;
    if ( clientConnection == nullptr )
    {
        return answer;
    }
    PluginRequest::Ptr request = PluginRequest::create( serverPluginName.toStdString(), data, answer );

    request->sendRequest( *clientConnection, NULL );

    request->receiveResponse( *clientConnection, NULL );
    return answer;
}
