/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2025                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_CALCULATION_H
#define CUBEGUI_CALCULATION_H

#include <functional>
#include <assert.h>

/** interface to use for parallel calculation of tasks */

namespace cubegui
{
class Task
{
public:
    Task()
    {
    }         // overwrite calculate() if the functional is not used
    Task( std::function<void()> func ) : defaultFunction( std::move( func ) )
    {
    }

    /** if isReady returns false, the task is executed after all other tasks have been processed */
    virtual bool
    isReady()
    {
        return true;
    }

    /** this function has to be implemented with calculations, that should be done in parallel */
    virtual void
    calculate()
    {
        assert( defaultFunction );
        defaultFunction();
    }

    virtual ~Task()
    {
    }

private:
    std::function<void()> defaultFunction;
};
}

#endif
