/****************************************************************************
**  CUBE        http://www.scalasca.org/                                   **
*****************************************************************************
**  Copyright (c) 1998-2022                                                **
**  Forschungszentrum Juelich GmbH, Juelich Supercomputing Centre          **
**                                                                         **
**  This software may be modified and distributed under the terms of       **
**  a BSD-style license.  See the COPYING file in the package base         **
**  directory for details.                                                 **
****************************************************************************/


#ifndef CUBEGUI_METRICTREEVIEW_H
#define CUBEGUI_METRICTREEVIEW_H

#include "TreeView.h"

namespace cubegui
{
/**
 * MetricTreeView extends the default tree view with new context menu items
 */
class MetricTreeView : public TreeView
{
    Q_OBJECT
public:
    MetricTreeView( TreeModelInterface* modelInterface,
                    const QString&      tabLabel );
    virtual void
    selectionChanged( const QItemSelection& selected,
                      const QItemSelection& deselected );

    virtual QString
    getContextDescription( TreeItem* item ) const;

protected:
    virtual void
    fillContextMenu();

    bool
    selectionIsValid( QList<TreeItem*>& oldItems,
                      TreeItem*         newItem );

private:
    enum MetricTreeContextMenuAction { MetricFullInfo };
};
}
#endif // METRICTREEVIEW_H
